define([
		'app',
		'SupportSummaryController',
		'SupportConstants'
	],
	function (app) {
		'use strict';
		app.config(function ($stateProvider) {
			$stateProvider
				.state('main.auth.two-panel.secondary-navigation.support', {
					url: '/support',
					appNavIndex: 4,
					containerClass: 'support',
					data: {
                        moduleName: "Support",
						appletName: "Support",
						panel: "secondary",
                        baseStateName : 'main.auth.two-panel.secondary-navigation.support',
                        initialState : "summary",
                        icon : "learn-managerelationships",
                        paramSections : [
                            {
                                paramValue : "mindfulness",
                                sectionName : "Mindfulness",
                                sectionIndex : 1,
                                backState : "^"
                            },
							{
								paramValue : "people-like-you",
								sectionName : "People Like You",
								sectionIndex : 2,
								backState : "^"
							},
							{
								paramValue : "family-friends",
								sectionName : "Family and Friends",
								sectionIndex : 3,
								backState : "^"
							},
							{
								paramValue : "health-providers",
								sectionName : "Health Providers",
								sectionIndex : 4,
								backState : "^"
							}
                        ]
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/support/pages/support-placeholder_template.html'
						}
					}
				})
                .state('main.auth.two-panel.secondary-navigation.support.summary', {
                    url: '/{section:mindfulness|people-like-you|family-friends|health-providers}/summary',
                    data: {
                        panel : "primary",
                        backState : "^"
                    },
                    views : {
                        'primary@main.auth.two-panel': {
                            templateUrl: 'src/modules/support/pages/summary/support-summary_template.html',
                            controller: 'SupportSummaryController'
                        }
                    }
                });
		});
	}
);
